' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.IO
Imports System.Text.RegularExpressions
Imports System.Web
Imports System.Web.UI.WebControls

Namespace Toolkit

  ''' <summary>
  ''' Klasa UploadFile jest owijk wok metody SaveAs kontrolki FileUpload.
  ''' Posiada publiczne waciwoci do sprawdzania rozszerzenia i rozmiaru wgranego na serwer pliku.
  ''' Posiada te waciwoci okrelajce czy powinny by tworzone pliki i foldery o unikalnych nazwach.
  ''' </summary>
  Public Class UploadHandler

    Private _VirtualSavePath As String = String.Empty
    Private _OverwriteExistingFile As Boolean = False
    Private _AllowedExtensions As String = String.Empty
    Private _FileName As String = String.Empty
    Private _Extension As String = String.Empty
    Private _NewDateFolder As String = String.Empty
    Private _GenerateUniqueFileName As Boolean = False
    Private _GenerateDateFolder As Boolean = False
    Private _PhysicalFolderAndFileName As String = String.Empty

    ''' <summary>
    ''' Chocia nie potrzeba dodawa deklaracji domylnego konstruktora publicznego, jest 
    ''' bardziej czytelne dla innych ludzi czytajcych kod, e mamy domylny konstruktor publiczny.
    ''' </summary>
    Public Sub New()

    End Sub

    ''' <summary>
    ''' Uploads a file.
    ''' </summary>
    ''' <param name="myFileUpload">Kontrolka &lt;asp:FileUpload&gt;, posiadajca plik, ktry trzeba zapisa.</param>
    ''' <exception cref="ArgumentException">Wyjtek rzucany, kiedy jedna z waciwoci zawiera niepoprawn warto. Ponisza tabela zawiera list rnych przypadkw, kiedy ten wyjtek jest rzucany oraz ParamName rzucanego wyjtku.
    ''' <list type="table">
    ''' <listheader>
    ''' <term>Nazwa Parametru</term>
    ''' <description>Powd, z ktrego wystpuje</description>
    ''' </listheader>
    ''' <item><term>VirtualSavePath</term>
    ''' <description>ArgumentException jest rzucany poniewa <see cref="VirtualSavePath" /> nie zostaa ustawiona.</description></item>
    ''' <item><term>FileName</term>
    ''' <description>ArgumentException jest rzucany poniewa <see cref="FileName" /> zawiera nazw pliku, ktry ju istnieje, a <see cref="OverwriteExistingFile" /> zostaa ustawiona na False.</description></item>
    ''' <item><term>Extension</term>
    ''' <description>ArgumentException jest rzucany, bo wgrany na serwer plik ma rozszerzenie, ktre nie spenia kryteriw ustalonych w <see cref="AllowedExtensions" />.</description></item>
    ''' <item><term>Extension</term>
    ''' <description>ArgumentException jest rzucany poniewa <paramref name="myFileUpload" /> nie posiada wgranego pliku.</description></item>
    ''' </list></exception>
    ''' <exception cref="UnauthorizedAccessException">Rzucany, kiedy w folderze podanym w <see cref="VirtualSavePath" /> nie mona zapisywa z powodu ogranicze dostpu.</exception>
    ''' <exception cref="Exception">Rzucany w razie wystapienia nieznanego bdu.</exception>
    Public Sub UploadFile(ByVal myFileUpload As FileUpload)
      If myFileUpload.HasFile Then
        ' Przygotuj nazwe pliku, rozszerzenie i nazw folderu
        If _GenerateUniqueFileName Then
          _FileName = Guid.NewGuid().ToString()
        Else
          If _FileName IsNot String.Empty Then
            _FileName = Path.GetFileNameWithoutExtension(myFileUpload.FileName)
          End If
        End If

        _Extension = System.IO.Path.GetExtension(myFileUpload.PostedFile.FileName)

        If _VirtualSavePath = String.Empty Then
          Throw New ArgumentException("Nie mona zapisa pliku bez " & _
                 "ustawienia VirtualSavePath.", "VirtualSavePath")
        End If
        If _GenerateDateFolder Then
          _VirtualSavePath &= DateTime.Now.Year.ToString() & _
                 "/" & DateTime.Now.Month.ToString().PadLeft(2, "0"c)
        End If

        _PhysicalFolderAndFileName = Path.Combine( _
              HttpContext.Current.Server.MapPath(_VirtualSavePath), _FileName)
        _PhysicalFolderAndFileName &= Extension

        If _OverwriteExistingFile = False Then
          If FileExists(_PhysicalFolderAndFileName) Then
            Throw New ArgumentException("Plik " & _FileName & " juz istnieje w folderze VirtualSavePath. Wybierz inn nazw lub ustaw _OverwriteExistingFile na True.", "FileName")
          End If
        End If

        If Not IsExtensionAllowed() Then
          Throw New ArgumentException("Plik " & _FileName & " ma niewaciwe rozszerzenie. Tylko nastpujce rozszerzenia s dopuszczalne: " & _AllowedExtensions & " .", "Extension")
        End If

        Try
          Dim myFolder As String = Path.GetDirectoryName(_PhysicalFolderAndFileName)
          If Not Directory.Exists(myFolder) Then
            Directory.CreateDirectory(myFolder)
          End If
          myFileUpload.PostedFile.SaveAs(_PhysicalFolderAndFileName)
        Catch uaex As UnauthorizedAccessException
          ' Nie mona zapisa pliku w danym folderze.
          Throw
        Catch Ex As Exception
          ' Wystpi nieznany bd.
          Throw
        End Try
      Else
        ' Nie zosta dodany plik. 
        Throw New ArgumentException("NIe mona zapisac pliku, bo nic nie zostao wgrane na serwer", "myFileUpload")
      End If
    End Sub

    ''' <summary>
    ''' Zwraca prawd lub fasz zalenie od tego, czy rozszerzenie wgranego pliku jest wymienione w wyraeniu regularnym _AllowedExtensions.
    ''' </summary>
    Private Function IsExtensionAllowed() As Boolean
      Dim tempResult As Boolean = True
      If _AllowedExtensions IsNot String.Empty Then
        Try
          tempResult = Regex.IsMatch(_Extension, _AllowedExtensions, RegexOptions.IgnoreCase)
        Catch
          tempResult = False
        End Try
      End If
      Return tempResult
    End Function

    ''' <summary>
    ''' Okresla, czy plik zawarty myFileName ju istnieje.
    ''' </summary>
    ''' <param name="myFileName">Fizyczne pooenie pliku do sprawdzenia.</param>
    Private Function FileExists(ByVal myFileName As String) As Boolean
      Return System.IO.File.Exists(myFileName)
    End Function

#Region "Waciwoci publiczne"

    ''' <summary>
    ''' Zwraca lub ustawia wirtualna ciek do folderu, gdzie musi by zapisany wgrany przez uytkownika plik.
    ''' Kiedy GenerateUniqueFileName lub GenerateDateFolder maj warto true, ta waciwo
    ''' jest modyfikowana przez metod UploadFile.
    ''' </summary>
    ''' <remarks>Ta waciwo wspiera katalogi wirtualne przy uyciu operatora katalogu gwnego aplikacji Web, tyldy (~).</remarks>
    Public Property VirtualSavePath() As String
      Get
        Return _VirtualSavePath
      End Get
      Set(ByVal Value As String)
        Value = Value.Replace("\", "/")

        If Not Value.EndsWith("/") Then
          Value &= "/"
        End If
        _VirtualSavePath = Value
      End Set
    End Property

    ''' <summary>
    ''' Zwraca bd ustawia warto okrelajc czy plik moe zosta nadpisany czy nie.
    ''' </summary>
    ''' <value>True, jeli plik docelowy moe zostac nadpisany, w przeciwnym wypadku False.</value>
    ''' <remarks>Ta waciwo nie daje efektu, gdy GenerateUniqueFileName ma warto True, poniewa tworzona jest unikalna nazwa.</remarks>
    Public Property OverwriteExistingFile() As Boolean
      Get
        Return _OverwriteExistingFile
      End Get
      Set(ByVal Value As Boolean)
        _OverwriteExistingFile = Value
      End Set
    End Property

    ''' <summary>
    ''' Zawiera wyraenie regularne uywane do sprawdzania rozszerzenia wgranego na serwer pliku. Moe by tak proste, jak "^.jpg|.gif$" aby dopuci wycznie pliki jpg i gif.
    ''' </summary>
    Public Property AllowedExtensions() As String
      Get
        Return _AllowedExtensions
      End Get
      Set(ByVal Value As String)
        _AllowedExtensions = Value
      End Set
    End Property

    ''' <summary>
    ''' Zwraca bd ustawia nazw zapisanego pliku.
    ''' </summary>
    Public Property FileName() As String
      Get
        Return _FileName
      End Get
      Set(ByVal Value As String)
        If Value.LastIndexOf(".") > 0 Then
          Value = Value.Substring(0, Value.LastIndexOf("."))
        End If
        _FileName = Value
      End Set
    End Property

    ''' <summary>
    ''' Zwraca rozszerzenie wgranego na serwer pliku.
    ''' </summary>
    Public ReadOnly Property Extension() As String
      Get
        Return _Extension
      End Get
    End Property

    ''' <summary>
    ''' Ustala, czy wgrany plik ma by zapisany z nazw wzita z Guid.
    ''' </summary>
    ''' <remarks>Ta waciwo domylnie ma warto False.</remarks>
    Public Property GenerateUniqueFileName() As Boolean
      Get
        Return _GenerateUniqueFileName
      End Get
      Set(ByVal Value As Boolean)
        _GenerateUniqueFileName = Value
      End Set
    End Property

    ''' <summary>
    ''' Ustala czy wgrany plik jest automatycznie zapisany w folderze z biec dat w formacie RRRR\MM.
    ''' </summary>
    ''' <remarks>Ta waciwo domylnie ma warto False.</remarks>
    Public Property GenerateDateFolder() As Boolean
      Get
        Return _GenerateDateFolder
      End Get
      Set(ByVal Value As Boolean)
        _GenerateDateFolder = Value
      End Set
    End Property

#End Region

  End Class
End Namespace